using System;

public class BankAccount
{
    private int accountNumber;
	private string accountHolder;
	protected int balance;

	
	public BankAccount(int n,string name ,int b)
    {
           accountNumber = n;
           accountHolder = name;
           balance = b;
    }

    public int AccountNumber
    {
        get { return accountNumber; }

        set { accountNumber = value; }
    }

    public string AccountHolder
    {
        get { return accountHolder; }

        set { accountHolder = value; }
    }

    public int Balance
    {
        get { return balance; }

        set
        {
            if (value > 0)
                balance = value;
            else
                balance = -1;
        }
    }
				
    public virtual void withdraw(int amount) 
	{ 
		if (balance>amount)
            balance-=amount;

        System.Console.WriteLine("Base class withdraw");
	}

	public void deposit(int amount) { balance+=amount;}
}

public class CurrentAccount : BankAccount
{
	private	int overdraftFacility;

    public CurrentAccount(int n, string name, int b, int ov) : base(n, name, b) { overdraftFacility = ov; }

    public override void withdraw(int amount) 
    {
        if (balance - amount > -overdraftFacility)
            balance -= amount;

         System.Console.WriteLine("Dervived class withdraw");
    }    
}

public class DepositAccount : BankAccount
{
    private double interestRate;

    public DepositAccount(int n, string name, int b, double rate) : base( n, name,b) { interestRate = rate; }

    double calcInterest()
    {
        double interest = balance * interestRate;
        balance += (int)(interest);
        return interest;
    } 	

}